/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.config.spec;

import com.momosoftworks.coldsweat.util.compat.CompatManager;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.serialization.ListBuilder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public class ItemSettingsConfig {
    private static final ForgeConfigSpec SPEC;
    private static final ForgeConfigSpec.Builder BUILDER;
    public static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> BOILER_FUELS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> ICEBOX_FUELS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> HEARTH_FUELS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> HEARTH_POTION_BLACKLIST;
    public static final ForgeConfigSpec.BooleanValue ALLOW_POTIONS_IN_HEARTH;
    public static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> SOULSPRING_LAMP_FUELS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> SOULSPRING_LAMP_DIMENSIONS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> FOOD_TEMPERATURES;
    public static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> CARRIED_ITEM_TEMPERATURE;
    public static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> INSULATION_ITEMS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> INSULATION_BLACKLIST;
    public static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> INSULATING_ARMOR;
    public static final ForgeConfigSpec.ConfigValue<List<?>> INSULATION_SLOTS;
    public static final ForgeConfigSpec.DoubleValue INSULATION_STRENGTH;
    public static final ForgeConfigSpec.IntValue WATERSKIN_STRENGTH;
    public static final ForgeConfigSpec.DoubleValue SOULSPRING_LAMP_STRENGTH;
    public static final ForgeConfigSpec.ConfigValue<List<? extends List<?>>> INSULATING_CURIOS;
    private static final ItemSettingsConfig INSTANCE;

    public static void setup() {
        Path configPath = FMLPaths.CONFIGDIR.get();
        Path csConfigPath = Paths.get(configPath.toAbsolutePath().toString(), "coldsweat");
        try {
            Files.createDirectory(csConfigPath, new FileAttribute[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SPEC, "coldsweat/item_settings.toml");
    }

    public void save() {
        SPEC.save();
    }

    public static ItemSettingsConfig getInstance() {
        return INSTANCE;
    }

    public List<? extends List<?>> getBoilerFuelItems() {
        return (List)BOILER_FUELS.get();
    }

    public List<? extends List<?>> getIceboxFuelItems() {
        return (List)ICEBOX_FUELS.get();
    }

    public List<? extends List<?>> getHearthFuelItems() {
        return (List)HEARTH_FUELS.get();
    }

    public List<? extends List<?>> getInsulationItems() {
        return (List)INSULATION_ITEMS.get();
    }

    public List<? extends List<?>> getInsulatingArmorItems() {
        return (List)INSULATING_ARMOR.get();
    }

    public List<?> getArmorInsulationSlots() {
        return (List)INSULATION_SLOTS.get();
    }

    public double getInsulationStrength() {
        return (Double)INSULATION_STRENGTH.get();
    }

    public List<? extends String> getInsulationBlacklist() {
        return (List)INSULATION_BLACKLIST.get();
    }

    public List<? extends List<?>> getSoulLampFuelItems() {
        return (List)SOULSPRING_LAMP_FUELS.get();
    }

    public List<? extends List<?>> getFoodTemperatures() {
        return (List)FOOD_TEMPERATURES.get();
    }

    public List<? extends String> getValidSoulLampDimensions() {
        return (List)SOULSPRING_LAMP_DIMENSIONS.get();
    }

    public int getWaterskinStrength() {
        return (Integer)WATERSKIN_STRENGTH.get();
    }

    public boolean arePotionsEnabled() {
        return (Boolean)ALLOW_POTIONS_IN_HEARTH.get();
    }

    public List<String> getPotionBlacklist() {
        return (List)HEARTH_POTION_BLACKLIST.get();
    }

    public List<? extends List<?>> getInsulatingCurios() {
        return CompatManager.isCuriosLoaded() ? (List)INSULATING_CURIOS.get() : List.of();
    }

    public List<? extends List<?>> getCarriedTemps() {
        return (List)CARRIED_ITEM_TEMPERATURE.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setBoilerFuelItems(List<? extends List<?>> itemMap) {
        ForgeConfigSpec.ConfigValue<List<? extends List<?>>> configValue = BOILER_FUELS;
        synchronized (configValue) {
            BOILER_FUELS.set(itemMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setIceboxFuelItems(List<? extends List<?>> itemMap) {
        ForgeConfigSpec.ConfigValue<List<? extends List<?>>> configValue = ICEBOX_FUELS;
        synchronized (configValue) {
            ICEBOX_FUELS.set(itemMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setHearthFuelItems(List<? extends List<?>> itemMap) {
        ForgeConfigSpec.ConfigValue<List<? extends List<?>>> configValue = HEARTH_FUELS;
        synchronized (configValue) {
            HEARTH_FUELS.set(itemMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setInsulationItems(List<? extends List<?>> items) {
        ForgeConfigSpec.ConfigValue<List<? extends List<?>>> configValue = INSULATION_ITEMS;
        synchronized (configValue) {
            INSULATION_ITEMS.set(items);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setInsulatingArmorItems(List<? extends List<?>> itemMap) {
        ForgeConfigSpec.ConfigValue<List<? extends List<?>>> configValue = INSULATING_ARMOR;
        synchronized (configValue) {
            INSULATING_ARMOR.set(itemMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setArmorInsulationSlots(List<?> slots) {
        ForgeConfigSpec.ConfigValue<List<?>> configValue = INSULATION_SLOTS;
        synchronized (configValue) {
            INSULATION_SLOTS.set(slots);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setInsulationStrength(double effectiveness) {
        ForgeConfigSpec.DoubleValue doubleValue = INSULATION_STRENGTH;
        synchronized (doubleValue) {
            INSULATION_STRENGTH.set((Object)effectiveness);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setSoulLampFuelItems(List<? extends List<?>> items) {
        ForgeConfigSpec.ConfigValue<List<? extends List<?>>> configValue = SOULSPRING_LAMP_FUELS;
        synchronized (configValue) {
            SOULSPRING_LAMP_FUELS.set(items);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setFoodTemperatures(List<? extends List<?>> itemMap) {
        ForgeConfigSpec.ConfigValue<List<? extends List<?>>> configValue = FOOD_TEMPERATURES;
        synchronized (configValue) {
            FOOD_TEMPERATURES.set(itemMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setValidSoulLampDimensions(List<? extends String> items) {
        ForgeConfigSpec.ConfigValue<List<? extends String>> configValue = SOULSPRING_LAMP_DIMENSIONS;
        synchronized (configValue) {
            SOULSPRING_LAMP_DIMENSIONS.set(items);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setWaterskinStrength(int strength) {
        ForgeConfigSpec.IntValue intValue = WATERSKIN_STRENGTH;
        synchronized (intValue) {
            WATERSKIN_STRENGTH.set((Object)strength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setPotionsEnabled(Boolean saver) {
        ForgeConfigSpec.BooleanValue booleanValue = ALLOW_POTIONS_IN_HEARTH;
        synchronized (booleanValue) {
            ALLOW_POTIONS_IN_HEARTH.set((Object)saver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setPotionBlacklist(List<String> saver) {
        ForgeConfigSpec.ConfigValue<List<? extends String>> configValue = HEARTH_POTION_BLACKLIST;
        synchronized (configValue) {
            HEARTH_POTION_BLACKLIST.set(saver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setInsulationBlacklist(List<String> blacklist) {
        ForgeConfigSpec.ConfigValue<List<? extends String>> configValue = INSULATION_BLACKLIST;
        synchronized (configValue) {
            INSULATION_BLACKLIST.set(blacklist);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setInsulatingCurios(List<? extends List<?>> items) {
        if (CompatManager.isCuriosLoaded()) {
            ForgeConfigSpec.ConfigValue<List<? extends List<?>>> configValue = INSULATING_CURIOS;
            synchronized (configValue) {
                INSULATING_CURIOS.set(items);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setCarriedTemps(List<? extends List<?>> items) {
        ForgeConfigSpec.ConfigValue<List<? extends List<?>>> configValue = CARRIED_ITEM_TEMPERATURE;
        synchronized (configValue) {
            CARRIED_ITEM_TEMPERATURE.set(items);
        }
    }

    static {
        BUILDER = new ForgeConfigSpec.Builder();
        INSTANCE = new ItemSettingsConfig();
        BUILDER.push("Fuel Items").comment(new String[]{"Defines items that can be used as fuel", "Format: [[\"item-id-1\", amount-1], [\"item-id-2\", amount-2], ...etc]"});
        BOILER_FUELS = BUILDER.defineListAllowEmpty(List.of("Boiler"), () -> ListBuilder.begin(new List[]{List.of("#minecraft:planks", Integer.valueOf(10)), List.of("minecraft:coal", Integer.valueOf(37)), List.of("minecraft:charcoal", Integer.valueOf(37)), List.of("#minecraft:logs_that_burn", Integer.valueOf(37)), List.of("minecraft:coal_block", Integer.valueOf(333)), List.of("minecraft:magma_block", Integer.valueOf(333)), List.of("minecraft:lava_bucket", Integer.valueOf(1000))}).build(), it -> {
            List list;
            return it instanceof List && (list = (List)it).size() == 2 && list.get(0) instanceof String && list.get(1) instanceof Number;
        });
        ICEBOX_FUELS = BUILDER.defineListAllowEmpty(List.of("Icebox"), () -> ListBuilder.begin(new List[]{List.of("minecraft:snowball", Integer.valueOf(10)), List.of("minecraft:clay_ball", Integer.valueOf(37)), List.of("minecraft:snow_block", Integer.valueOf(100)), List.of("minecraft:ice", Integer.valueOf(250)), List.of("minecraft:clay", Integer.valueOf(333)), List.of("minecraft:powder_snow_bucket", Integer.valueOf(100)), List.of("minecraft:packed_ice", Integer.valueOf(1000))}).build(), it -> {
            List list;
            return it instanceof List && (list = (List)it).size() == 2 && list.get(0) instanceof String && list.get(1) instanceof Number;
        });
        HEARTH_FUELS = BUILDER.comment("Negative values indicate cold fuel").defineListAllowEmpty(List.of("Hearth"), () -> ListBuilder.begin(new List[]{List.of("#minecraft:planks", Integer.valueOf(10)), List.of("minecraft:coal", Integer.valueOf(37)), List.of("minecraft:charcoal", Integer.valueOf(37)), List.of("#minecraft:logs_that_burn", Integer.valueOf(37)), List.of("minecraft:coal_block", Integer.valueOf(333)), List.of("minecraft:magma_block", Integer.valueOf(333)), List.of("minecraft:lava_bucket", Integer.valueOf(1000)), List.of("minecraft:snowball", Integer.valueOf(-10)), List.of("minecraft:clay_ball", Integer.valueOf(-37)), List.of("minecraft:snow_block", Integer.valueOf(-100)), List.of("minecraft:ice", Integer.valueOf(-250)), List.of("minecraft:clay", Integer.valueOf(-333)), List.of("minecraft:powder_snow_bucket", Integer.valueOf(-100)), List.of("minecraft:packed_ice", Integer.valueOf(-1000))}).build(), it -> {
            List list;
            return it instanceof List && (list = (List)it).size() == 2 && list.get(0) instanceof String && list.get(1) instanceof Number;
        });
        HEARTH_POTION_BLACKLIST = BUILDER.comment(new String[]{"Potions containing any of these effects will not be allowed in the hearth", "Format: [\"effect_id\", \"effect_id\", ...etc]"}).defineListAllowEmpty(List.of("Blacklisted Hearth Potions"), () -> ListBuilder.begin(new String[]{"minecraft:instant_damage", "minecraft:poison", "minecraft:wither", "minecraft:weakness", "minecraft:mining_fatigue", "minecraft:slowness"}).build(), it -> it instanceof String);
        ALLOW_POTIONS_IN_HEARTH = BUILDER.comment(new String[]{"If true, potions can be used as fuel in the hearth", "This gives all players in range the potion effect"}).define("Allow Potions in Hearth", true);
        BUILDER.pop();
        BUILDER.push("Soulspring Lamp");
        SOULSPRING_LAMP_FUELS = BUILDER.comment(new String[]{"Defines items that the Soulspring Lamp can use as fuel", "Format: [[\"item-id-1\", amount-1], [\"item-id-2\", amount-2], ...etc]"}).defineListAllowEmpty(List.of("Fuel Items"), () -> ListBuilder.begin(List.of("cold_sweat:soul_sprout", Integer.valueOf(4))).build(), it -> {
            List list;
            return it instanceof List && (list = (List)it).size() == 2 && list.get(0) instanceof String && list.get(1) instanceof Number;
        });
        SOULSPRING_LAMP_DIMENSIONS = BUILDER.comment(new String[]{"Defines the dimensions that the Soulspring Lamp can be used in", "Format: [\"dimension-id-1\", \"dimension-id-2\", ...etc]"}).defineListAllowEmpty(List.of("Valid Dimensions"), () -> ListBuilder.begin("minecraft:the_nether").build(), it -> it instanceof String);
        BUILDER.pop();
        BUILDER.push("Insulation");
        INSULATION_ITEMS = BUILDER.comment(new String[]{"Defines the items that can be used for insulating armor in the Sewing Table", "Format: [[\"item_id\", cold, hot, \"static\", *nbt], [\"item_id\", amount, adapt-speed, \"adaptive\", *nbt], ...etc]", "\"item_id\": The item's ID (i.e. \"minecraft:iron_ingot\"). Accepts tags with \"#\" (i.e. \"#minecraft:wool\").", "", "Adaptive Insulation: ", "\"amount\": The amount of insulation the item provides.", "\"adapt-speed\": The speed at which the insulation adapts to the environment.", "*\"type\": Optional. Either \"static\" or \"adaptive\". Defines the insulation type. Defaults to static.", "*\"nbt\": Optional. If set, the item will only provide insulation if it has the specified NBT tag.", "", "Static Insulation: ", "\"cold\": The amount of cold insulation the item provides.", "\"hot\": The amount of heat insulation the item provides.", "*\"type\": Optional. Either \"static\" or \"adaptive\". Defines the insulation type. Defaults to static.", "*\"nbt\": Optional. If set, the item will only provide insulation if it has the specified NBT tag."}).defineListAllowEmpty(List.of("Insulation Ingredients"), () -> ListBuilder.begin(new List[]{List.of("minecraft:leather_helmet", Integer.valueOf(4), Integer.valueOf(4)), List.of("minecraft:leather_chestplate", Integer.valueOf(6), Integer.valueOf(6)), List.of("minecraft:leather_leggings", Integer.valueOf(5), Integer.valueOf(5)), List.of("minecraft:leather_boots", Integer.valueOf(4), Integer.valueOf(4)), List.of("minecraft:leather", Integer.valueOf(1), Integer.valueOf(1)), List.of("cold_sweat:chameleon_molt", Integer.valueOf(2), Double.valueOf(0.0085), "adaptive"), List.of("cold_sweat:hoglin_hide", Integer.valueOf(0), Integer.valueOf(2)), List.of("cold_sweat:goat_fur", Integer.valueOf(2), Integer.valueOf(0)), List.of("#minecraft:wool", Double.valueOf(1.5), Integer.valueOf(0)), List.of("minecraft:rabbit_hide", Integer.valueOf(0), Double.valueOf(1.5)), List.of("cold_sweat:hoglin_headpiece", Integer.valueOf(0), Integer.valueOf(8)), List.of("cold_sweat:hoglin_tunic", Integer.valueOf(0), Integer.valueOf(12)), List.of("cold_sweat:hoglin_trousers", Integer.valueOf(0), Integer.valueOf(10)), List.of("cold_sweat:hoglin_hooves", Integer.valueOf(0), Integer.valueOf(8)), List.of("cold_sweat:goat_fur_cap", Integer.valueOf(8), Integer.valueOf(0)), List.of("cold_sweat:goat_fur_parka", Integer.valueOf(12), Integer.valueOf(0)), List.of("cold_sweat:goat_fur_pants", Integer.valueOf(10), Integer.valueOf(0)), List.of("cold_sweat:goat_fur_boots", Integer.valueOf(8), Integer.valueOf(0))}).addIf(CompatManager.isEnvironmentalLoaded(), (Supplier<List[]>)((Supplier<List>)() -> List.of("environmental:yak_hair", Double.valueOf(1.5), Integer.valueOf(-1)))).build(), it -> {
            List list;
            return !(!(it instanceof List) || (list = (List)it).size() < 3 || !(list.get(0) instanceof String) || !(list.get(1) instanceof Number) || !(list.get(2) instanceof Number) || list.size() >= 4 && !(list.get(3) instanceof String) || list.size() >= 5 && !(list.get(4) instanceof String));
        });
        INSULATING_ARMOR = BUILDER.comment(new String[]{"Defines the items that provide insulation when worn", "See Insulation Ingredients for formatting"}).defineListAllowEmpty(List.of("Insulating Armor"), () -> ListBuilder.begin(new List[]{List.of("minecraft:leather_helmet", Integer.valueOf(4), Integer.valueOf(4)), List.of("minecraft:leather_chestplate", Integer.valueOf(6), Integer.valueOf(6)), List.of("minecraft:leather_leggings", Integer.valueOf(5), Integer.valueOf(5)), List.of("minecraft:leather_boots", Integer.valueOf(4), Integer.valueOf(4)), List.of("cold_sweat:hoglin_headpiece", Integer.valueOf(0), Integer.valueOf(8)), List.of("cold_sweat:hoglin_tunic", Integer.valueOf(0), Integer.valueOf(12)), List.of("cold_sweat:hoglin_trousers", Integer.valueOf(0), Integer.valueOf(10)), List.of("cold_sweat:hoglin_hooves", Integer.valueOf(0), Integer.valueOf(8)), List.of("cold_sweat:goat_fur_cap", Integer.valueOf(8), Integer.valueOf(0)), List.of("cold_sweat:goat_fur_parka", Integer.valueOf(12), Integer.valueOf(0)), List.of("cold_sweat:goat_fur_pants", Integer.valueOf(10), Integer.valueOf(0)), List.of("cold_sweat:goat_fur_boots", Integer.valueOf(8), Integer.valueOf(0))}).addIf(CompatManager.isEnvironmentalLoaded(), (Supplier<List[]>)((Supplier<List>)() -> List.of("environmental:yak_pants", Double.valueOf(7.5), Integer.valueOf(-5)))).build(), it -> {
            List list;
            return !(!(it instanceof List) || (list = (List)it).size() < 3 || !(list.get(0) instanceof String) || !(list.get(1) instanceof Number) || !(list.get(2) instanceof Number) || list.size() >= 4 && !(list.get(3) instanceof String) || list.size() >= 5 && !(list.get(4) instanceof String));
        });
        INSULATING_CURIOS = CompatManager.isCuriosLoaded() ? BUILDER.comment(new String[]{"Defines the items that provide insulation when worn in a curio slot", "See Insulation Ingredients for formatting"}).defineListAllowEmpty(List.of("Insulating Curios"), () -> List.of(), it -> {
            List list;
            return !(!(it instanceof List) || (list = (List)it).size() < 3 || !(list.get(0) instanceof String) || !(list.get(1) instanceof Number) || !(list.get(2) instanceof Number) || list.size() >= 4 && !(list.get(3) instanceof String) || list.size() >= 5 && !(list.get(4) instanceof String));
        }) : null;
        INSULATION_SLOTS = BUILDER.comment(new String[]{"Defines how many insulation slots armor pieces have", "There are 4 modes for this setting:", "Static: Each armor slot (head, body, legs, feet) has a fixed number of insulation slots", "- Format: [head, body, legs, feet] (a list of integers; insulation slot count for each armor slot)", " ", "Linear: Number of slots increases steadily with protection", "Exponential: Number of slots increases rapidly with protection", "Logarithmic: Number of slots increases with protection, with diminishing returns", "- Format: [number, max-slots] (a positive integer or decimal; the rate of increase)"}).defineList("Insulation Slots", List.of("static", Integer.valueOf(4), Integer.valueOf(6), Integer.valueOf(5), Integer.valueOf(4)), it -> it instanceof Number || it instanceof String);
        INSULATION_STRENGTH = BUILDER.comment("Defines the effectiveness of insulating items in protecting against temperature").defineInRange("Insulation Strength", 1.0, 0.0, Double.MAX_VALUE);
        INSULATION_BLACKLIST = BUILDER.comment(new String[]{"Defines wearable items that cannot be insulated", "Format: [\"item_id\", \"item_id\", ...etc]"}).defineListAllowEmpty(List.of("Insulation Blacklist"), () -> List.of(), it -> it instanceof String);
        BUILDER.pop();
        BUILDER.push("Consumables");
        FOOD_TEMPERATURES = BUILDER.comment(new String[]{"Defines items that affect the player's temperature when consumed", "Format: [[\"item_id\", amount, *nbt, *duration], [\"item_id\", amount, *nbt, *duration], ...etc]", "Negative values are cold foods, positive values are hot foods", "nbt: Optional. If set, the item will only affect the player's temperature if it has the specified NBT tag.", "duration: Optional. If set, the player's temperature will remain increased/decreased for this amount of time (in ticks)."}).defineListAllowEmpty(List.of("Temperature-Affecting Foods"), () -> Arrays.asList(List.of("cold_sweat:soul_sprout", Integer.valueOf(-20), "{}", Integer.valueOf(1200))), it -> {
            List list;
            return !(!(it instanceof List) || (list = (List)it).size() < 2 || !(list.get(0) instanceof String) || !(list.get(1) instanceof Number) || list.size() >= 3 && !(list.get(2) instanceof String) || list.size() >= 4 && !(list.get(3) instanceof Number));
        });
        WATERSKIN_STRENGTH = BUILDER.comment("Defines how much a waterskin will change the player's body temperature by when used").defineInRange("Waterskin Strength", 50, 0, Integer.MAX_VALUE);
        SOULSPRING_LAMP_STRENGTH = BUILDER.comment(new String[]{"Determines the strength of the Soulspring Lamp's effect before it is overwhelmed", "A value of 1 means it will never be overwhelmed"}).defineInRange("Soulspring Lamp Strength", 0.6, 0.0, 1.0);
        BUILDER.pop();
        BUILDER.push("Misc");
        CARRIED_ITEM_TEMPERATURE = BUILDER.comment(new String[]{"Defines items that affect the player's temperature when in the inventory", "Format: [[\"item_id\", temperature, strict_type, trait, *nbt, *max_effect], [\"item_id\", temperature, strict_type, trait, *nbt, *max_effect], ...etc]", "temperature: The temperature change the item will apply to the entity. For core temperature, this is applied every tick", "strict_type: Either \"inventory\", \"hotbar\", or \"hand\". Defines what slots the item must be in to apply to the entity", "trait: The temperature trait to apply the effect to. Typical values are \"core\" for body temperature or \"world\" for ambient temperature. More on the mod documentation page.", "nbt: Optional. The NBT data the item must have to apply to the entity.", "max_effect: Optional. The maximum temperature effect the item can apply to the entity."}).defineListAllowEmpty(List.of("Carried Item Temperatures"), () -> List.of(), it -> {
            List list;
            return !(!(it instanceof List) || !CSMath.betweenInclusive((list = (List)it).size(), 4.0, 6.0) || !(list.get(0) instanceof String) || !(list.get(1) instanceof Number) || !(list.get(2) instanceof String) || !(list.get(3) instanceof String) || list.size() >= 5 && !(list.get(4) instanceof String) || list.size() >= 6 && !(list.get(5) instanceof Number));
        });
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

